﻿/*	AVAILABLE DATA
	thisCommand_obj
		data						This command's data
		run()						This function
		nextEvent()			Function that triggers the next sibling command
		storeTimeout()	Function that stores this command's timeout ID   (used to stop the script)
			var waitId = setTimeout( parentScript.nextEvent, thisCommand_obj.data.value*1000 );
			thisCommand_obj.storeTimeout( waitId );
*/
// run()
define_sound = function( thisCommand_obj ){
	
	
	thisCommand_obj.soundLoop = ROOT.soundLoop;		// allow this command to access the sound loop tracker
	if(TRACE_SCRIPT)
		trace("sound");
	var soundFile = thisCommand_obj.data.file;
	var loopName = thisCommand_obj.data.name;
	if(soundFile != "")
	{// if:  sound file is populated
		var volume = thisCommand_obj.data.volume;
		var loop = thisCommand_obj.data.loop;
		var sound_obj = SOUND.play( soundFile, volume, loop );
		// if looping, then store this sound
		if( loopName )
			ROOT.soundLoop.addSound( loopName, sound_obj, true );
	}// if:  sound file is populated
	else
	{// if:  sound file is empty
		// stop the looping sound
		if(loopName!=""){
			ROOT.soundLoop.remove( loopName );
		}else{
			SOUND.stopAll();
		}
	}// if:  sound file is empty
	
	
	// instantly done
	return VOW.make().keep();
	
	
}// define_sound()